#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <mpi.h>

int main(int argc, char **argv) {
   char sendbuf[20];
   char *recvbuf = NULL;

   int msgsize, size, rank;

   MPI_Status status;

   MPI_Init(&argc,&argv);
   MPI_Comm_size(MPI_COMM_WORLD, &size);
   MPI_Comm_rank(MPI_COMM_WORLD, &rank);

   if(size != 2) MPI_Abort(MPI_COMM_WORLD, 1);

   if(rank == 0) {
      strcpy(sendbuf, "Hello Mate!");
      MPI_Send(sendbuf, strlen(sendbuf)+1, MPI_CHAR, 1, 10, MPI_COMM_WORLD);
   } else {
      MPI_Probe(MPI_ANY_SOURCE, MPI_ANY_TAG, MPI_COMM_WORLD, &status);
      MPI_Get_count(&status, MPI_CHAR, &msgsize);

      printf("Message incoming from process %d with tag %d and size %d\n",
             status.MPI_SOURCE, status.MPI_TAG, msgsize);

      if (msgsize != MPI_UNDEFINED)
         recvbuf = (char *)malloc(msgsize*sizeof(char));

      MPI_Recv(recvbuf, msgsize, MPI_CHAR, status.MPI_SOURCE, status.MPI_TAG, MPI_COMM_WORLD, NULL);

      printf("Received message: %s\n", recvbuf);
   }

   MPI_Finalize();

   return 0;
}