#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char* argv[]) {
  MPI_Init(&argc, &argv);

  int size, rank;
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) {
    int buffer[3] = {123, 456, 789};
    printf("Process %d: sending 3 ints: %d, %d, %d\n", rank, buffer[0], buffer[1], buffer[2]);
    MPI_Send(buffer, 3, MPI_INT, 1, 10, MPI_COMM_WORLD);
  } else if (rank == 1) {
    MPI_Status status;
    int count;

    MPI_Probe(0, 10, MPI_COMM_WORLD, &status);
    MPI_Get_count(&status, MPI_INT, &count);

    printf("Process %d retrieved the size of the message: %d.\n", rank, count);

    int* buffer = (int*)malloc(sizeof(int) * count);
    MPI_Recv(buffer, count, MPI_INT, 0, 10, MPI_COMM_WORLD, &status);

    printf("Process %d received message:", rank);
    for(int i = 0; i < count; ++i)
      printf(" %d", buffer[i]);
    printf(".\n");

    free(buffer);
  }

  MPI_Finalize();

  return 0;
}