#include <stdio.h>
#include <mpi.h>

#define BUFSZ 5

int main(int argc, char* argv[]) {
  double buf[BUFSZ];
  
  int rank;
  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) {
    for(unsigned int i = 0; i < BUFSZ; i++) buf[i] = (double)i;
    MPI_Send(buf, BUFSZ, MPI_DOUBLE, 1, 99, MPI_COMM_WORLD);
  } else if(rank == 1) {
    MPI_Recv(buf, BUFSZ, MPI_DOUBLE, 0, 99, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
  }
  
  printf("Process with rank %d: ", rank);
  for(unsigned int i = 0; i < BUFSZ; i++)
    printf("%5.1lf", buf[i]);
  printf("\n");

  MPI_Finalize();

  return 0;
}