#include <mpi.h>
#include <string.h>
#include <stdio.h>

int main(int argc, char* argv[]) {
  char msg[20];
  int rank, recv_count, tag = 99;
  MPI_Status status;

  MPI_Init(&argc, &argv);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) {
    strcpy(msg, "Hello mate!");
    MPI_Send(msg, strlen(msg)+1, MPI_CHAR, 1, tag, MPI_COMM_WORLD);

    printf("Process %d send: %s\n", rank, msg);
  } else if(rank == 1) {
    MPI_Recv(msg, 20, MPI_CHAR, 0, tag, MPI_COMM_WORLD, &status);
    MPI_Get_count(&status, MPI_CHAR, &recv_count);

    printf("Process %d received: %s (size = %d)\n", rank, msg, recv_count);
  }

  MPI_Finalize();

  return 0;
}