#include <stdio.h>
#include <stdlib.h>
#include <mpi.h>

int main(int argc, char* argv[]) {
  const unsigned int N = 10000000;

  int rank, size;
  MPI_Init(&argc, &argv);
  MPI_Comm_size(MPI_COMM_WORLD, &size);
  MPI_Comm_rank(MPI_COMM_WORLD, &rank);

  if (rank == 0) 
    printf("Running with %d processes.\n", size);

  unsigned int startidx = (N * rank / size) + 1;
  unsigned int   endidx = N * (rank+1) / size;

  unsigned long lsum = 0;
  for (unsigned int i = startidx; i <= endidx; ++i)
    lsum += i;
  
  printf("Process %d has local sum %lu\n", rank, lsum);

  if (rank > 0) {
    MPI_Send(&lsum, 1, MPI_UNSIGNED_LONG, 0, 1, MPI_COMM_WORLD);
  } else {
    unsigned long rsum;
    for(int src = 1; src < size; ++src) {
      MPI_Recv(&rsum, 1, MPI_UNSIGNED_LONG, src, 1, MPI_COMM_WORLD, MPI_STATUS_IGNORE);
      lsum += rsum;
    }
  }

  if(rank == 0) printf("The sum of 1 to %d is %lu.\n", N, lsum);

  MPI_Finalize();

  return 0;
}