#include <stdio.h>  // for printf
#include <stdlib.h> // for malloc, free and exit

/**
 * This demonstrates how to create array, assign values to array element and
 * retrieve the value of array elements.
 * 
 * Compile with: gcc -o array array.c
 * Run with: ./array
 */

int main(void) {
  /** Create a 1D array of integers of size 4 */
  int array1[4];

  /** Fill the array */
  for (int i = 0; i < 4; i++)
    array1[i] = i+1;

  /** Print the array */
  printf("1D array:\n");
  for (int i = 0; i < 4; i++)
    printf("\t%d", array1[i]);

  printf("\n\n");

  /** Create a 2D array of integers of size 3 x 3 */
  int array2[3][3];

  /** Fill the array */
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++)
    array2[i][j] = i+j+1;
  }

  /** Print the array */
  printf("2D array:\n");
  for (int i = 0; i < 3; i++) {
    for (int j = 0; j < 3; j++) {
      printf("\t%d", array2[i][j]);
    }

    printf("\n");
  }

  printf("\n");

  double *array3;

  /** Create a dynamically allocated array and check that malloc succeeded */
  if ((array3 = (double*)malloc(sizeof(double) * 4)) == NULL) {
    printf("Allocation failed!\n");
    exit(1);
  }

  /** Fill the array */
  for (int i = 0; i < 4; i++)
    array3[i] = (double)(i+1);

  /** Print the array */
  printf("Dynamic 1D array:\n");
  for (int i = 0; i < 4; i++)
    printf("\t%lf", array3[i]);

  printf("\n\n");

  /** Make sure to deallocate any array allocated with malloc */
  free(array3);
}