#include <stdio.h> // for printf

/**
 * This demonstrates how to print to the use of the if-if else-else statement
 * as well as the relational and logical operators
 * 
 * Compile with: gcc -o conditional conditional.c
 * Run with: ./conditional
 */

int main(void) {
  int a = 1;
  int b = 2;
  int c = 3;
  int d = 4;

  printf("a = %d, b = %d, c = %d, d = %d\n", a, b, c, d);

  if (a < b) printf("a < b is true\n");

  if (a > b) 
    printf("a > b is true\n");
  else
    printf("a > b is false\n");

  /** a < b true, c < d true -> true and true = true */
  if (a < b && c < d) printf("a > b && c < d is true\n");
  
  /** a < b true, c > d false -> true and false = false */
  if (a < b && c > d) 
    printf("a > b and c > d is true\n");
  else
    printf("a > b and c > d is false\n");

  /** a < b true, c > d false -> true or false = true */
  if (a < b || c > d) 
    printf("a > b or c > d is true\n");
  else
    printf("a > b or c > d is false\n");

  /** 
   * a < b true and c < d true as well but a < b comes first so, only the if
   * statement is executed, not the else if
   * */
  if (a < b){
    printf("a < b is true\n");
  } else if (c < d) {
    printf("c < d is true\n");
  }

  /** a > b false and c < d true, else if statement executed  */
  if (a > b){
    printf("a < b is true\n");
  } else if (c < d) {
    printf("c < d is true\n");
  }

  /** a > b false but we use the not (!) operator: not false = true  */
  if (!(a > b)){
    printf("not (a > b) is true\n");
  }

  return 0;
}