#include <stdio.h> // for printf

/**
 * This demonstrates basic use of custom data types
 * 
 * Compile with: gcc -o structure structure.c
 * Run with: ./structure
 */

typedef struct {
   int x;
   int y;
} point;


int main(void) {

  /** Define a variable p of type point, and initialize it the members */
  point p = { 1, 2 };
  
  /**
   * Define a variable q of type point, and set members values using designated
   * initializers, i.e., member name
   */
  point q = { .y = 4, .x = 3 };

  /**
   * Value of the members can be accessed using varname.membername
   */
  printf("p = {x = %d, y = %d}, q = {x = %d, y = %d}\n", p.x, p.y, q.x, q.y);

  /** You can assign a custom type variable with a variable of the same type */
  point r = p;
  printf("r = {x = %d, y = %d}, p = {x = %d, y = %d}\n", r.x, r.y, p.x, p.y);
}