#include <stdio.h>  // for printf

/**
 * This demonstarte how to print to the standard output
 * 
 * Compile with: gcc -o formatted_printing formatted_printing.c
 * Run with: ./formatted_printing
 */

int main(void) {
    const char* str = "hello";

    int               a = 1;
    unsigned int      b = 2;
    long int          c = 3;
    unsigned long int d = 4;
    double            e = 1.234;

    printf("Print a string: %s\n", str);

    printf("Print an integer: %d\n", a);
    printf("Print an unsigned integer: %u\n", b);
    printf("Print an long integer: %ld\n", c);
    printf("Print an unsigned long integer: %lu\n", d);
    printf("Print integer with left padding: %5d\n", a);
    printf("Print integer with zero padding: %05d\n", a);

    printf("Print a double %lf\n", e);
    printf("Print a double with 4 decimals %.4lf\n", e);
    printf("Print a double with 4 decimals and left padding: %10.4lf\n", e);
    printf("Print a double in scientific format: %le\n", e);
    printf("Print a double in scientific format with 4 decimals: %.4le\n", e);
}
