#include <stdio.h> // for printf

/**
 * This demonstrates how to print to the use of the if-if else-else statement
 * as well as the relational and logical operators
 * 
 * Compile with: gcc -o function function.c
 * Run with: ./function
 */

/**
 * Functions need to be defined before they are used in the source file. Here, 
 * the body (code) of the print_sum function is defined after main which calls 
 * it, so we need to define it here to avoid compilation error.
 */
void print_sum(double sum);

/**
 * Define a function that takes two parameters, a and b of type double
 * and returns the sum as a double as well
 */
double sum(double a, double b) {
  printf("from function %s: a = %lf, b = %lf\n", __FUNCTION__, a, b);

  return a + b;
}

int main(void) {
  printf("Calling function sum...\n");
  double s = sum(1.0, 2.0);
  
  printf("Calling function print_sum...\n");
  print_sum(s);

  return 0;
}

/**
 * If a function does not return a value, then it's of type void and return
 * statement can be omitted
 */
void print_sum(double sum) {
  printf("Sum is %lf\n", sum);
}