#include <stdio.h> // for printf

/**
 * This demonstrates how to use for loops to repeat the same sequence 
 * of intructions multiple times
 * 
 * Compile with: gcc -o loop loop.c
 * Run with: ./loop
 */

int main(void) {

  /**
   * Loop will do 5 iterations: Initialization i = 0, at each step increment by
   * 1 and check if i < 5
   */
  for (int i = 0; i < 5; i++) {
    printf("LOOP1: i = %d\n", i);
  }

  printf("\n");

  /**
   * Loop will do 3 iterations: Initialization i = 0, at each step increment by
   * 2 and check if i < 5
   */
  for (int i = 0; i < 5; i += 2) {
    printf("LOOP2: i = %d\n", i);
  }

  printf("\n");

  /**
   * The iteration variable can be declared outside of the for statement and
   * the value used for multiple loop
   */
  int k = 0;
  for (; k < 5; k++) {
    printf("LOOP3: k = %d\n", k);
  }

  /** at that point k == 5 **/
  for (; k < 10; k += 3) {
    printf("LOOP4: k = %d\n", k);
  }

  printf("\n");

  /** 
   * You can exit a loop early using the break statement
   */
  for (int i = 0; i < 5; i++) {
    /** if i == 3 then we exit the loop */
    if (i == 3) {
      printf("i = %d, exiting loop...\n", i);
      break;
    }

    printf("LOOP5: i = %d\n", i);
  }

  return 0;
}
