#include <stdio.h>  // for printf
#include <stdlib.h> // for malloc

/**
 * This demontrates the use of pointers
 * 
 * Compile with: gcc -o pointers pointers.c
 * Run with: ./pointers
 */

void set_value(int c) {
  c = 1234;

  printf("c in %s: %d (%p)\n", __FUNCTION__, c, &c);
}

void set_value_pointer(int* c) {
  int lc = 1234;
  *c = lc;

  printf("c in %s: %d (%p)\n", __FUNCTION__, lc, c);
}

int main(void) {
  int a = 1234;

  printf("a = %d, &a = %p\n", a, &a);

  /** Allocate an array with one int element */
  int* b = malloc(sizeof(int));
  b[0] = 1234; // *b = 1234 is equivalent

  /**
   * b is a pointer, i.e., an adress in memory
   * b[0] is the value of the first element, i.e. the value stored at adress b 
   * *b deference the b pointer, i.e., the value stored at the adress b
   * &b[0] returns the adress of the first element of the b array, i.e. the b pointer
   */
  printf("b = %p, b[0] = %d, *b = %d, &b[0] = %p\n", b, b[0], *b, &b[0]);
  /** b was allocated with malloc, we need to free the memory */
  free(b);

  int c = 0;
  /**
   * Modification of a function parameter inside a function will not be 
   * visible to the calling function if the parameter is passed by value.
   * The function will receive a copy of the value that will be discarted when
   * exiting the function
   */
  set_value(c);
  printf("c in %s: %d (%p)\n", __FUNCTION__, c, &c);

  /**
   * Modification of a function parameter inside a function will be 
   * visible to the calling function if the parameter is passed by reference, 
   * i.e., using a pointer. The function will receive an adress where to store
   * the value. This value will visible to the calling function exiting the 
   * function
   */
  set_value_pointer(&c);
  printf("c in %s: %d (%p)\n", __FUNCTION__, c, &c);

  return 0;
}