#include <stdio.h>
#include <omp.h>

#define NSTEPS 10000000000UL

int main(int argc, const char* argv[]) {
  const double step = 1.0 / NSTEPS;
  double sum = 0.0;
  double pi = 0.0;

  double start = omp_get_wtime();

  #pragma omp parallel for
  for(unsigned long i = 0; i < NSTEPS; i++) {
    double x1 = (i + 0.5) * step;
    double f = 4.0/(1.0 + x1 * x1);

    #pragma omp atomic
    sum += f;
  }

  pi = sum * step;
  
  double elapsed = omp_get_wtime() - start;

  printf("PI = %.16g computed in %.4g seconds\n", pi, elapsed);

  return 0;
}