#include <stdio.h>
#include <omp.h>

#define NSTEPS 10000000000UL

#pragma omp declare simd
double pi_step(unsigned long i, double step) {
  double x = (i + 0.5) * step;
  return 1.0/(1.0 + x * x);
}

int main(int argc, const char* argv[]) {
  double sum = 0.0;
  double step = 1.0 / NSTEPS;

  double start = omp_get_wtime();

  #pragma omp parallel for simd reduction(+:sum) 
  for(unsigned long i = 0; i < NSTEPS; i++) {
    sum += pi_step(i, step);
  }

  double elapsed = omp_get_wtime() - start;
  double pi = 4.0 * step * sum;

  printf("PI = %.16g computed in %.4g seconds\n", pi, elapsed);

  return 0;
}