#include <stdio.h>
#include <omp.h>

int main(int argc, char* argv[]) {
	int nthreads, tid;
	int a = 2;

	#pragma omp parallel shared(nthreads, a) private(tid)	
	{
		tid = omp_get_thread_num();

		#pragma omp single 
		nthreads = omp_get_num_threads();

		#pragma omp for lastprivate(a)
		for(int i = 0; i < nthreads; ++i) {
			a = i;

			printf("Thread %d: iteration %d, a = %d.\n", tid, i, a);
		}

		printf("Thread %d: a = %d.\n", tid, a);
	}
}