#include <stdio.h>
#include <omp.h>

int main(int argc, char* argv[]) {
  int max_threads = omp_get_max_threads();
  int iterations[max_threads];

  for(int i = 0; i < max_threads; ++i)
    iterations[i] = 0;

  #pragma omp parallel
  {
      for(int i = 0; i < 1000; ++i)
        iterations[omp_get_thread_num()]++;
  }

  for(int i = 0; i < max_threads; ++i)
    printf("Number of iteration for thread %d: %d\n", i, iterations[i]);
  
  return 0;
}