#include <stdio.h>
#include <stdlib.h>
#include <time.h>

int main(int argc, char* argv[]) {
	srand(time(NULL));

	double a[8], b[8], c[8], d[8];

	for(unsigned int i = 0; i < 8; ++i) {
		a[i] = rand() / (double)(RAND_MAX / 10);
		b[i] = rand() / (double)(RAND_MAX / 10);
	}

#pragma omp parallel shared(a, b, c, d)
{
	#pragma omp for
	for(unsigned int i = 0; i < 8; ++i)
		c[i] = a[i] + b[i];

	#pragma omp single nowait
	printf("The first element of c is %lf.\n", c[0]);

	#pragma omp for
	for(unsigned int i = 0; i < 8; ++i)
		d[i] = c[i] * b[i];

	#pragma omp single
	printf("The last element of d is %lf.\n", d[0]);
}

	return 0;
}