#include <stdio.h>
#include <omp.h>

#define MAX(a, b) (a) > (b) ? (a) : (b)

int main(int argc, char* argv[]) {
    int n = 100;

    int a[n];

    #pragma omp for
    for (int i = 0; i < n; ++i)
        a[i] = i;

    int tid, local_sum, local_max;
    int sum = 0, max = 0;
    #pragma omp parallel shared(sum, max) private(tid, local_sum, local_max)
    {
        tid = omp_get_thread_num(); 
        local_sum = 0;
        local_max = 0;
    
        #pragma omp for
        for (unsigned int i = 0; i < n; ++i) {
            local_sum += a[i];
            local_max = MAX(local_max, a[i]);
        }
    
        #pragma omp critical(sum)
        {
            sum += local_sum;
            printf("Thread %d: local sum = %d, sum = %d.\n", 
                    tid, local_sum, sum);
        }

        #pragma omp critical(max)
        {
            max = MAX(max, local_max);
            printf("Thread %d: local max = %d, max = %d.\n", 
                    tid, local_max, max);
        }
    }
    
    printf("Sum after parallel region: %d.\n", sum);
    printf("Max after parallel region: %d.\n", max);

    return 0;
}