#include <stdio.h>
#include <omp.h>

int main(int argc, char* argv[]) {
	int nthreads, tid;

	#pragma omp parallel shared(nthreads) private(tid)
	{
		tid = omp_get_thread_num();
		
		#pragma omp single 
		{
			nthreads = omp_get_num_threads();
			printf("Hello, I'm thread %d of %d in the single construct.\n", tid, nthreads);
		}

		printf("Hello, I'm thread %d of %d.\n", tid, nthreads);
	}
}