#include <stdio.h>
#include <omp.h>

int main(int argc, char* argv[]) {
  int max_threads = omp_get_max_threads();
  int iterations[max_threads];

  for(int i = 0; i < max_threads; ++i)
    iterations[i] = 0;

  int n = 1000;
  #pragma omp parallel
  {
    int tid = omp_get_thread_num();

    #pragma omp for
    for(int i = 0; i < n; ++i)
      iterations[tid]++;
  }

  for(int i = 0; i < max_threads; ++i)
    printf("Number of iteration for thread %d: %d\n", i, iterations[i]);
  
  return 0;
}