#include <stdio.h>
#include <omp.h>

#define MAX(a, b) (a) > (b) ? (a) : (b)

int main(int argc, char* argv[]) {
    int n = 100;

    int a[n];

    #pragma omp for
    for (int i = 0; i < n; ++i)
        a[i] = i;

    int sum = 0, max = 0;
    #pragma omp parallel for reduction(+:sum) reduction(max:max)
    for (unsigned int i = 0; i < n; ++i) {
        sum += a[i];
        max = MAX(max, a[i]);
    }
    
    printf("Sum after parallel region: %d.\n", sum);
    printf("Max after parallel region: %d.\n", max);

    return 0;
}