/* [...........................................................] */

#include "decode.h"

/* [...........................................................] */

/*
 * Function: DecodeIP(u_int8_t *, const u_int32_t, Packet *)
 *
 * Purpose: Decode the IP network layer
 *
 * Arguments: pkt => ptr to the packet data
 *            len => length from here to the end of the packet
 *            p   => pointer to the packet decode struct
 *
 * Returns: void function
 */
void DecodeIP(u_int8_t * pkt, const u_int32_t len, Packet * p)
{
/* [...] */

    /* lay the IP struct over the raw data */
    p->iph = (IPHdr *) pkt;

/* [...] */

    /* set the IP datagram length */
    ip_len = ntohs(p->iph->ip_len);

/* [...] */

    /* set the IP header length */
    hlen = p->iph->ip_hlen << 2;

/* [...] */

    /* set the remaining packet length */
    ip_len -= hlen;

/* [...] */

#ifdef DEBUG
        printf("IP header length: %lu\n", (unsigned long)hlen);
#endif

        switch(p->iph->ip_proto)
        {
	/* [...] */

            case IPPROTO_ICMP:
                pc.icmp++;
                DecodeICMP(pkt + hlen, ip_len, p);
                ClearDumpBuf();
                return;

	/* [...] */

        }

/* [...] */

}

/* [...........................................................] */


/*
 * Function: DecodeICMP(u_int8_t *, const u_int32_t, Packet *)
 *
 * Purpose: Decode the ICMP transport layer
 *
 * Arguments: pkt => ptr to the packet data
 *            len => length from here to the end of the packet
 *            p   => pointer to the decoded packet struct
 *
 * Returns: void function
 */
void DecodeICMP(u_int8_t * pkt, const u_int32_t len, Packet * p)
{

/* [...] */

    p->dsize = (u_short)(len - ICMP_HEADER_LEN);
    p->data = pkt + ICMP_HEADER_LEN;

#ifdef DEBUG
    printf("ICMP type: %d   code: %d\n", p->icmph->code, p->icmph->type);
#endif

    switch(p->icmph->type)
    {
        case ICMP_ECHOREPLY:
            /* setup the pkt id ans seq numbers */
            p->dsize -= sizeof(struct idseq);
            p->data += sizeof(struct idseq);
            break;

        case ICMP_ECHO:
            /* setup the pkt id and seq numbers */
            p->dsize -= sizeof(struct idseq);   /* add the size of the 
                                                 * echo ext to the data
                                                 * ptr and subtract it 
                                                 * from the data size */
            p->data += sizeof(struct idseq);
            break;

		/* [...] */
    }

    return;
}



