/* [...........................................................] */

#define ICMP_HEADER_LEN         8

/* [...........................................................] */

#define ICMP_ECHOREPLY          0    /* Echo Reply                   */
#define ICMP_DEST_UNREACH       3    /* Destination Unreachable      */
#define ICMP_SOURCE_QUENCH      4    /* Source Quench                */
#define ICMP_REDIRECT           5    /* Redirect (change route)      */
#define ICMP_ECHO               8    /* Echo Request                 */
#define ICMP_ROUTER_ADVERTISE   9    /* Router Advertisement         */
#define ICMP_ROUTER_SOLICIT     10    /* Router Solicitation          */
#define ICMP_TIME_EXCEEDED      11    /* Time Exceeded                */
#define ICMP_PARAMETERPROB      12    /* Parameter Problem            */
#define ICMP_TIMESTAMP          13    /* Timestamp Request            */
#define ICMP_TIMESTAMPREPLY     14    /* Timestamp Reply              */
#define ICMP_INFO_REQUEST       15    /* Information Request          */
#define ICMP_INFO_REPLY         16    /* Information Reply            */
#define ICMP_ADDRESS            17    /* Address Mask Request         */
#define ICMP_ADDRESSREPLY       18    /* Address Mask Reply           */
#define NR_ICMP_TYPES           18

/* [...........................................................] */

typedef struct _IPHdr
{
#if defined(WORDS_BIGENDIAN)
    u_int8_t ip_ver:4,  /* IP version */
    ip_hlen:4;          /* IP header length */
#else
    u_int8_t ip_hlen:4, ip_ver:4;
#endif
    u_int8_t ip_tos;        /* type of service */
    u_int16_t ip_len;       /* datagram length */
    u_int16_t ip_id;        /* identification  */
    u_int16_t ip_off;       /* fragment offset */
    u_int8_t ip_ttl;        /* time to live field */
    u_int8_t ip_proto;      /* datagram protocol */
    u_int16_t ip_csum;      /* checksum */
    struct in_addr ip_src;  /* source IP */
    struct in_addr ip_dst;  /* dest IP */
}      IPHdr;

/* [...........................................................] */

typedef struct _ICMPHdr
{
    u_int8_t type;
    u_int8_t code;
    u_int16_t csum;
    union
    {
    	
	/* [...] */
	
        struct idseq
        {
            u_int16_t id;
            u_int16_t seq;
        } idseq;
        
	/* [...] */
	
    } icmp_hun;

#define s_icmp_id         icmp_hun.idseq.id
#define s_icmp_seq        icmp_hun.idseq.seq

/* [...] */

}        ICMPHdr;


/* [...........................................................] */

void DecodeIP(u_int8_t *, const u_int32_t, Packet *);
void DecodeICMP(u_int8_t *, const u_int32_t, Packet *);