/********************************************************/
/*     S P P _ H T T P _ 4 0 4 . C                      */
/********************************************************/
/* Created by Dredger on 05/04/2002                     */
/********************************************************/

#include "spp_http_404.h"

/* Dfinition des variables globales: */
/*------------------------------------*/
Http404_Global_Struct	H4G;

/************************************/
/* Registration du prprocesseur: 	*/
/************************************/
void SetupHttp404()
{
    RegisterPreprocessor("http_404", Http404Init);
    DebugMessage(DEBUG_PLUGIN, "Preprocessor: Http404 in setup...\n");
}

/************************************/
/* Initialisation du prprocesseur: */
/************************************/
void Http404Init(u_char *args)
{
	float NbMax=10;
	float NbSecs=60;
	char *TmpTxt;
	int ArgLen;
	int a,b;
	
    DebugMessage(DEBUG_PLUGIN, "Preprocessor: Http404 Initialized\n");

/* Initialisation des variables: */
/*-------------------------------*/
	H4G.FCell=Http404_New_Cell(0);
	H4G.FCell->Next=H4G.FCell;
	H4G.FCell->Prev=H4G.FCell;
	H4G.Cell_TimeOut=60;
	H4G.Cell_Nb=1;
	H4G.Pack_IP=0;
	
/* Dcodage des arguments: */
/*-------------------------*/
	a=b=0;
	ArgLen=strlen(args);
	while(a<ArgLen)
	{
		while((args[a]!='-')&&(args[a]!=0))a++;
		if(args[a++]==0)break;
		TmpTxt=args+a;
		while((args[a]>='a')&&(args[a]<='z'))a++;
		args[a++]=0;
		if(strcmp(TmpTxt,"src")==0){H4G.Pack_IP=0;continue;}
		if(strcmp(TmpTxt,"dest")==0){H4G.Pack_IP=1;continue;}
		if(strcmp(TmpTxt,"to")==0)
		{
			H4G.Cell_TimeOut=0;
			while((args[a]>='0')&&(args[a]<='9'))
				H4G.Cell_TimeOut=H4G.Cell_TimeOut*10+args[a++]-'0';
		}
		if(strcmp(TmpTxt,"nb")==0)
		{
			NbMax=0;
			while((args[a]>='0')&&(args[a]<='9'))
				NbMax=NbMax*10+args[a++]-'0';
		}
		if(strcmp(TmpTxt,"ti")==0)
		{
			NbSecs=0;
			while((args[a]>='0')&&(args[a]<='9'))
				NbSecs=NbSecs*10+args[a++]-'0';
		}
	}
	
/* Traitage des arguments: */
/*-------------------------*/
	NbMax/=1.3;
	
	H4G.Count_Add=NbSecs/NbMax;
	H4G.Count_k=-log((NbSecs-(NbSecs/NbMax))/NbSecs)/(NbSecs/NbMax);
	H4G.Count_Max=NbSecs;
	
	printf("k=%f; Max=%f; Add=%f\r\n",H4G.Count_k,H4G.Count_Max,H4G.Count_Add);

	
/* Enregistrement des fonctions: */
/*-------------------------------*/
    AddFuncToPreprocList(Http404_PreProc_Fct);
    AddFuncToCleanExitList(Http404_Clean_Exit,(void *)25);
}


/************************************/
/* Dsaloue tout ce qui l'a t. 	*/
/************************************/
void Http404_Clean_Exit(int Signal, void *arg)
{
	Http404_List_Struct *Cell1, *Cell2;

/* Dsaloue toutes les cellules: */
	Cell1=H4G.FCell;
	while(Cell1!=NULL)
	{
		printf("Et encore une cellule!! %X\r\n",(int)Cell1);
		Cell2=Cell1->Next;
		if(Cell2==H4G.FCell)Cell2=NULL;		// Attention, liste circulaire.
		free(Cell1);
		Cell1=Cell2;
	}
}

/************************************/
/* Analyse un packet. 				*/
/************************************/
void Http404_PreProc_Fct(Packet *p)
{
    /* check to make sure we're talking TCP and that the TWH has already
       completed before processing anything */
    if(!PacketIsTCP(p))
    {
        DebugMessage(DEBUG_PLUGIN, "It isn't TCP session traffic\n");
        return;
    }

    if(!IsTcpSessionTraffic(p))
    {
        DebugMessage(DEBUG_PLUGIN, "It isn't TCP session traffic\n");
        return;
    }
	
// Teste s'il y a assez de donne pour etre une rponse HTTP.
	if(p->dsize<15)
	{
        DebugMessage(DEBUG_PLUGIN, "Not enough data to be a HTTP response.\n");
        return;
	}
	
// Teste si c'est une rponse HTTP.
	if(*((int*)p->data)!='PTTH')
	{
        DebugMessage(DEBUG_PLUGIN, "Not an HTTP response.\n");
        return;
	}
	
// Teste si c'est un code 404.
	if(*((int*)p->data+2)!='404 ')
	{
       	DebugMessage(DEBUG_PLUGIN, "Not a \"404 page not found\" response.\n");
		return;
	}
	
/* A partir d'ici, on a affaire  un code 404. */
/*---------------------------------------------*/
	if(H4G.Pack_IP==0)
		Http404_New_404(ntohl(p->iph->ip_src.s_addr));
	else
		Http404_New_404(ntohl(p->iph->ip_dst.s_addr));
}


/************************************/
/* Traite une nouvelle erreur 404. 	*/
/************************************/
void Http404_New_404(unsigned int IP_Addr)
{
	Http404_List_Struct *Cur_Cell;
	double Now;
	Event event;
	char *AlertTxt;
	struct in_addr Addr;
	
	Addr.s_addr=htonl(IP_Addr);
	printf("Erreur 404 pour IP: %s\r\n",inet_ntoa(Addr));
	Cur_Cell=Http404_Find_Cell(IP_Addr);
	Http404_Show_List(H4G.FCell);
	Now=Http404_Get_Time();

	Cur_Cell->Count=Cur_Cell->Count*exp(-H4G.Count_k*(Now-Cur_Cell->Time))+H4G.Count_Add;	// C=C*exp(-k*dt)+Add
	Cur_Cell->Time=Now;
	printf("Count: %f\r\n",Cur_Cell->Count);
	if(Cur_Cell->Count>H4G.Count_Max)
	{
		AlertTxt=(char *)malloc(1024);
		Addr.s_addr=htonl(Cur_Cell->IP_Addr);
		sprintf(AlertTxt,"HTTP 404 Error Flood by %s!",inet_ntoa(Addr));
		printf("ALEEEEEEEEEEEEEERT!!!!\r\n");
		SetEvent(&event,GENERATOR_SPP_HTTP_404,HTTP_404_FLOOD_ATTACK,1,0,0,0);
		CallAlertFuncs(NULL,AlertTxt,NULL,&event);
		free(AlertTxt);
		H4G.FCell=Cur_Cell->Next;
		Http404_Delete_Cell(Cur_Cell);
	}
	
	printf("\r\n");
}

/************************************/
/* Cherche une cellule de la liste.	*/
/************************************/
Http404_List_Struct *Http404_Find_Cell(unsigned int IP_Addr)
{
	Http404_List_Struct *Cell1, *Cell2, *Cell3;
	unsigned int Dist;
	unsigned int OldDist;
	double Now;
	int Sens;
	
// Remarque: Il y a toujours au moins une cellule (au moins l'adresse IP 0).	
	Now=Http404_Get_Time();
	Cell1=H4G.FCell;

/* Dtermine le sens de parcours de la liste: */
/*--------------------------------------------*/
	Sens=0;
	Dist=IP_Addr-Cell1->IP_Addr;
	if(Dist==0)return(Cell1);
	if(Dist>(1<<30))
	{
		Dist=-Dist;
		Sens=1;
	}

	OldDist=Dist;
	Cell2=Cell1;
	Cell1=Sens?Cell1->Prev:Cell1->Next;

	if((Cell2->IP_Addr!=0)&&(Cell2->Time<Now-H4G.Cell_TimeOut))
		Http404_Delete_Cell(Cell2);
	
/* Parcours la liste: */
/*--------------------*/
	while(Cell1!=H4G.FCell)
	{
		Dist=Sens?(Cell1->IP_Addr-IP_Addr):(IP_Addr-Cell1->IP_Addr);

	// Si on a trouv la bonne cellule:
		if(Dist==0)
		{
			H4G.FCell=Cell1;
			return(Cell1);
		}

	// Si on a dpass l'adresse IP:
		if((Dist<0)||(Dist>OldDist))break;
		
	// Sinon, on passe  la suivante:
		OldDist=Dist;
		Cell2=Cell1;
		Cell1=Sens?Cell1->Prev:Cell1->Next;
		if((Cell2->IP_Addr!=0)&&(Cell2->Time<Now-H4G.Cell_TimeOut))
			Http404_Delete_Cell(Cell2);
	}

/* Insre une nouvelle cellule: */
/*------------------------------*/
	H4G.Cell_Nb++;
	Cell2=Http404_New_Cell(IP_Addr);
	if(Sens==0)
	{
		Cell3=Cell1;
		Cell1=Cell3->Prev;
	}
	else
	{
		Cell3=Cell1->Next;
	}
	Cell2->Next=Cell3;
	Cell2->Prev=Cell1;
	Cell1->Next=Cell2;
	Cell3->Prev=Cell2;

	H4G.FCell=Cell2;
	return(Cell2);
}


/************************************/
/* Cre une nouvelle cellule.		*/
/************************************/
Http404_List_Struct *Http404_New_Cell(unsigned int IP_Addr)
{
	Http404_List_Struct *New_Cell;

	New_Cell=malloc(sizeof(Http404_List_Struct));
	New_Cell->IP_Addr=IP_Addr;
	New_Cell->Time=Http404_Get_Time();
	New_Cell->Count=0;
	New_Cell->Next=NULL;
	New_Cell->Prev=NULL;

	return(New_Cell);
}

/************************************/
/* Efface une cellule.				*/
/************************************/
void Http404_Delete_Cell(Http404_List_Struct *zeCell)
{
	Http404_List_Struct *Cell1,*Cell2;
	
// Remarque: Il est toujours cens en rester une aprs.
	
	printf("Got to delete Cell: %X\r\n",zeCell->IP_Addr);

	Cell1=zeCell->Prev;
	Cell2=zeCell->Next;
	
	Cell1->Next=Cell2;
	Cell2->Prev=Cell1;
	
	free(zeCell);
}

/************************************/
/* Affiche la liste.				*/
/************************************/
void Http404_Show_List(Http404_List_Struct *FCell)
{
	Http404_List_Struct *zeCell;
	struct in_addr Addr;
	
	zeCell=NULL;
	while(zeCell!=FCell)
	{
		if(zeCell==NULL)
			zeCell=FCell;
		Addr.s_addr=htonl(zeCell->IP_Addr);
		printf("|%s| -> ",inet_ntoa(Addr));
		zeCell=zeCell->Next;
	}
	printf("\r\n");
}

/************************************/
/* Renvoie l'heure (prcise).		*/
/************************************/
double Http404_Get_Time()
{
	double Now;
	struct timeval tv;
	struct timezone tz;
	
	gettimeofday(&tv,&tz);
	Now=tv.tv_usec;
	Now/=1000000;
	Now+=tv.tv_sec;
	return(Now);	
}