/********************************************************/
/*     S P P _ H T T P _ 4 0 4 . H                      */
/********************************************************/
/* Created by Dredger on 05/04/2002                     */
/********************************************************/
#ifndef __SPP_HTTP_404__H
#define __SPP_HTTP_404__H

#include "snort.h"

/* Dfinition de la structure de liste doublement lie: */
/*------------------------------------------------------*/
typedef struct {
	unsigned int IP_Addr;
	double Time;
	float Count;
	void *Prev;
	void *Next;
} Http404_List_Struct;

/* Dfinition de la structure des variables globales: */
/*----------------------------------------------------*/
typedef struct {
// Variables pour les cellules de la liste lie:
	Http404_List_Struct	*FCell;		// Cellules de la liste doublement lie.
	int Cell_Nb;					// Nombre de cellules.
	int Cell_TimeOut;				// Nombre max de secondes qu'on garde une cellule inactive en mmoire.

// Variables pour la slection des paquets:
	int Pack_IP;					// IP  utiliser (0=src; 1=dest).
	
// Variables pour la gestion des compteurs:
	float Count_k;					// Coefficient de dcrmentation exponentielle.
	float Count_Add;				// Coefficient d'addition.
	float Count_Max;				// Seuil de dtection.
} Http404_Global_Struct;


/* Dfinition des fonctions: */
/*---------------------------*/
void SetupHttp404();
void Http404Init(u_char *args);
void Http404_Clean_Exit(int Signal, void *arg);
void Http404_PreProc_Fct(Packet *p);
void Http404_New_404(unsigned int IP_Addr);

Http404_List_Struct *Http404_Find_Cell(unsigned int IP_Addr);
Http404_List_Struct *Http404_New_Cell(unsigned int IP_Addr);
void Http404_Delete_Cell(Http404_List_Struct *zeCell);
void Http404_Show_List(Http404_List_Struct *FCell);

double Http404_Get_Time();


#endif // __SPP_HTTP_404__H