#include <algorithm>
#include <iostream>
#include <string>
#include <vector>

using std::cin; using std::cout; using std::endl;
using std::sort; using std::streamsize;
using std::string; using std::vector;

int main() {
    // Ask for and read the student's name
    cout << "Please enter your first name: ";
    string name;
    cin >> name;
    cout << "Hello, " << name << "!" << endl;

    // Ask for and read the midterm and final grades
    cout << "Please enter your midterm and final exam grades: ";
    double midterm, final;
    cin >> midterm >> final;

    // Ask for and read the homework grades
    cout << "Enter all your homework grades, "
            "followed by end-of-file: ";

    vector<double> homeworks;
    double x;
    // Invariant: `homeworks` contains all the
    // homework grades read so far
    while (cin >> x)
        homeworks.push_back(x);

    // Check the student entered some homework grades
    typedef vector<double>::size_type vec_sz;
    vec_sz size = homeworks.size();
    if (size == 0) {
        cout << endl << "You must enter your grades.  "
                        "Please try again." << endl;
        return 1;
    }

    // Sort the grades
    sort(homeworks.begin(), homeworks.end());

    // Compute the median homework grade
    vec_sz mid = size / 2;
    double median = (size % 2 == 0)
        ? (homeworks[mid] + homeworks[mid - 1]) / 2
        : homeworks[mid];

    // Compute and write the final grade
    double final_grade =
        0.2 * midterm + 0.4 * final + 0.4 * median;
    streamsize prec = cout.precision(3); // Set precision
    cout << "Your final grade is " << final_grade << endl;
    cout.precision(prec); // Restore original precision

    return 0;
}
