#include "student_info.hh"

#include <cassert>
#include <list>

using namespace std;

static bool fgrade(const Student_info& s);
static vector<Student_info> extract_fails_1(vector<Student_info>& students);
static vector<Student_info> extract_fails_2(vector<Student_info>& students);
static vector<Student_info> extract_fails_3(vector<Student_info>& students);
static list<Student_info> extract_fails_4(list<Student_info>& students);

bool fgrade(const Student_info& s) {
    return grade(s) < 60;
}

vector<Student_info> extract_fails_1(vector<Student_info>& students) {
    vector<Student_info> passes, fails;

    for (vector<Student_info>::size_type i = 0;
            i != students.size(); ++i)
        if (fgrade(students[i]))
            fails.push_back(students[i]);
        else
            passes.push_back(students[i]);

    students = passes;
    return fails;
}

vector<Student_info> extract_fails_2(vector<Student_info>& students) {
    vector<Student_info> fails;
    vector<Student_info>::size_type i = 0;

    // Invariant: elements `[0,i)` of `students` are passing grades
    while (i != students.size())
        if (fgrade(students[i])) {
            fails.push_back(students[i]);
            students.erase(students.begin() + i);
        } else
            ++i;

    return fails;
}

vector<Student_info>
extract_fails_3(vector<Student_info>& students) {
    vector<Student_info> fails;
    vector<Student_info>::iterator iter = students.begin();

    while (iter != students.end())
        if (fgrade(*iter)) {
            fails.push_back(*iter);
            iter = students.erase(iter);
        } else
            ++iter;

    return fails;
}

list<Student_info>
extract_fails_4(list<Student_info>& students) {
    list<Student_info> fails;
    list<Student_info>::iterator iter = students.begin();

    while (iter != students.end())
        if (fgrade(*iter)) {
            fails.push_back(*iter);
            iter = students.erase(iter);
        } else
            ++iter;

    return fails;
}

int main() {
    Student_info pass1 = { "Pass1", 92., 89., vector<double> { 52., 65. } };
    Student_info fail = { "Fail", 1.4, 3.5, vector<double> { 1.2, 4.5 } };
    Student_info pass2 = { "Pass2", 82., 79., vector<double> { 62., 75. } };
    vector<Student_info> students = { pass1, fail, pass2 };
    vector<Student_info> vec;
    vector<Student_info> fails;
    vector<vector<Student_info> (*)(vector<Student_info>&)> funcs = {
        extract_fails_1, extract_fails_2, extract_fails_3
    };

    for (auto f : funcs) {
        vec = students;
        fails = f(vec);
        assert(fails.size() == 1);
        assert(fails[0].name == "Fail");
        assert(vec.size() == 2);
        assert(vec[0].name == "Pass1");
        assert(vec[1].name == "Pass2");
    }

    list<Student_info> lst = { pass1, fail, pass2 };
    list<Student_info> fails_lst;
    fails_lst = extract_fails_4(lst);
    assert(fails_lst.size() == 1);
    assert(fails_lst.front().name == "Fail");
    assert(lst.size() == 2);
    assert(lst.front().name == "Pass1");
    assert(lst.back().name == "Pass2");

    return 0;
}
