#include <iomanip>
#include <iostream>
#include <vector>

#include "grade.hh"

using namespace std;

int main() {
    // Ask for and read student's name
    cout << "Please enter your first name: ";
    string name;
    cin >> name;
    cout << "Hello, " << name << "!" << endl;

    // Ask for and read midterm and final grades
    cout << "Please enter your midterm and final exam grades: ";
    double midterm, final;
    cin >> midterm >> final;

    // Ask for and read homework grades
    cout << "Enter all your homework grades, "
            "followed by end-of-file: ";
    vector<double> homeworks;
    read_hws(cin, homeworks);

    // Compute and generate final grade, if possible
    try {
        double final_grade = grade(midterm, final, homeworks);
        streamsize prec = cout.precision();
        cout << "Your final grade is " << setprecision(3)
             << final_grade << setprecision(prec) << endl;
    } catch (domain_error) {
        cerr << endl << "You must enter your grades.  "
                        "Please try again." << endl;
        return 1;
    }

    return 0;
}
