#include <cctype>
#include <iostream>
#include <string>
#include <vector>

using namespace std;

static vector<string> split(const string& s);
static string::size_type width(const vector<string>& v);
static vector<string> frame(const vector<string>& v);
static vector<string> vcat(const vector<string>& top,
                           const vector<string>& bottom);
static vector<string> hcat(const vector<string>& left,
                           const vector<string>& right);

vector<string> split(const string& s) {
    vector<string> ret;
    string::size_type i = 0;

    // Invariant: we have processed characters `[0,i)`
    while (i != s.size()) {
        // Find word first character
        while (i != s.size() && isspace(s[i]))
            ++i;
        // Find end of next word
        string::size_type j = i;
        while (j != s.size() && !isspace(s[j]))
            ++j;
        // If we found some non-whitespace characters
        if (i != j) {
            // Copy word to vector
            ret.push_back(s.substr(i, j - i));
            i = j;
        }
    }
    return ret;
}

string::size_type width(const vector<string>& v) {
    string::size_type maxlen = 0;
    for (auto& s : v) // No need for const here
        maxlen = max(maxlen, s.size());
    return maxlen;
}

vector<string> frame(const vector<string>& v) {
    vector<string> ret;
    string::size_type maxlen = width(v);
    string border(maxlen + 4, '*');

    // Write the top border
    ret.push_back(border);
    // Write each interior row, bordered by an asterisk and a space
    for (auto& s : v)
        ret.push_back(
            "* " + s + string(maxlen - s.size(), ' ') + " *");
    // Write the bottom border
    ret.push_back(border);

    return ret;
}

vector<string> vcat(const vector<string>& top,
                    const vector<string>& bottom) {
    // Copy top picture
    vector<string> ret = top;
    // Copy bottom picture
    for (auto& s : bottom)
        ret.push_back(s);

    return ret;
}

vector<string> hcat(const vector<string>& left,
                    const vector<string>& right) {
    vector<string> ret;
    // Add 1 to leave a space between pictures
    string::size_type width1 = width(left) + 1;
    // Indices to look at elements from `left` and `right` respectively
    vector<string>::size_type i = 0, j = 0;
    // Continue until we've seen all rows from both pictures
    while (i != left.size() || j != right.size()) {
        // Construct new string to hold characters from both pictures
        string s;
        // Copy a row from the left-hand side, if there is one
        if (i != left.size())
            s = left[i++];
        // Pad to full width
        s += string(width1 - s.size(), ' ');
        // Copy a row from the right-hand side, if there is one
        if (j != right.size())
            s += right[j++];
        // Add `s` to the picture we're creating
        ret.push_back(s);
    }
    return ret;
}

int main() {
    vector<string> top_left = split("  One Two  Three  ");
    vector<string> top_right = { "Four", "Five" };
    vector<string> bot = { "", "Lorem ipsum dolor",
                           "sic amet." };

    vector<string> top = hcat(top_left, top_right);
    vector<string> all = vcat(top, bot);
    vector<string> framed = frame(all);

    for (auto& s : framed)
        cout << s << endl;

    return 0;
}
