#include "student_info.hh"

#include <algorithm>
#include <cassert>

using namespace std;

static bool fgrade(const Student_info& s) {
    return grade(s) < 60;
}

static vector<Student_info> extract_fails_1(vector<Student_info>&);
static vector<Student_info> extract_fails_2(vector<Student_info>&);

static bool pgrade(const Student_info& s) {
    return !fgrade(s);
}

vector<Student_info> extract_fails_1(vector<Student_info>& students)
{
    vector<Student_info> fails;
    copy_if(students.begin(), students.end(),
            back_inserter(fails), fgrade);
    students.erase(remove_if(students.begin(), students.end(),
                             fgrade),
                   students.end());
    return fails;
}

vector<Student_info> extract_fails_2(
        vector<Student_info>& students)
{
    vector<Student_info>::iterator iter =
        stable_partition(students.begin(), students.end(), pgrade);
    vector<Student_info> fails(iter, students.end());
    students.erase(iter, students.end());
    return fails;
}

int main() {
    Student_info pass1 = { "Pass1", 92., 89., vector<double> { 52., 65. } };
    Student_info fail = { "Fail", 1.4, 3.5, vector<double> { 1.2, 4.5 } };
    Student_info pass2 = { "Pass2", 82., 79., vector<double> { 62., 75. } };
    vector<Student_info> students = { pass1, fail, pass2 };
    vector<Student_info> vec;
    vector<Student_info> fails;
    vector<vector<Student_info> (*)(vector<Student_info>&)> funcs = {
        extract_fails_1, extract_fails_2
    };

    for (auto f : funcs) {
        vec = students;
        fails = f(vec);
        assert(fails.size() == 1);
        assert(fails[0].name == "Fail");
        assert(vec.size() == 2);
        assert(vec[0].name == "Pass1");
        assert(vec[1].name == "Pass2");
    }

    return 0;
}
