#include "grade.hh"

#include <stdexcept>

#include "median.hh"

using namespace std;

double grade(double midterm, double final, double homework)
{
    return 0.2 * midterm + 0.4 * final + 0.4 * homework;
}

double grade(double midterm, double final,
             const vector<double>& homeworks)
{
    if (homeworks.empty())
        throw domain_error("student has done no homework");
    return grade(midterm, final, median(homeworks));
}

istream& read_hws(istream& in, vector<double>& hws) {
    if (in) {
        // Get rid of previous contents
        hws.clear();

        // Read homework grades
        double grade;
        while (in >> grade)
            hws.push_back(grade);

        // Clear the stream so that input will work
        // for the next student
        in.clear();
    }
    return in;
}
