#include "split.hh"

#include <algorithm>
#include <cassert>
#include <cctype>

using namespace std;

static bool is_space(char c) { return isspace(c); }

vector<string> split(const string& s) {
    typedef string::const_iterator iter;
    vector<string> ret;

    iter i = s.begin();
    while (i != s.end()) {
        // Find start of next word
        i = find_if_not(i, s.end(), is_space);
        // Find end of next word
        iter j = find_if(i, s.end(), is_space);
        // Copy the characters in [i, j)
        if (i != s.end())
            ret.push_back(string(i, j));
        i = j;
    }
    return ret;
}
