#include <iostream>
#include <map>
#include <vector>

#include "split.hh"

using namespace std;

// Find all the lines that refer to each word in the input.
static map<string, vector<int> >
xref(istream& in, vector<string> find_words(const string&) = split)
{
    string line;
    int line_number = 0;
    map<string, vector<int> > ret;

    // Read the next line
    while (getline(in, line)) {
        ++line_number;
        // Break the input line into words
        vector<string> words = find_words(line);
        // Remember that each word occurs on the current line
        for (const auto& w : words)
            ret[w].push_back(line_number);
    }

    return ret;
}

int main() {
    // Call `xref` using `split` (default)
    map<string, vector<int>> ret = xref(cin);

    // Write the results
    for (const auto& p : ret) {
        // Write the word
        cout << p.first << " occurs on line(s): ";
        // Followed by one or more line numbers
        auto line_it = p.second.cbegin();
        cout << *line_it; // Write the first line number
        // Write the rest of the line numbers, if any
        ++line_it;
        while (line_it != p.second.end()) {
            cout << ", " << *line_it;
            ++line_it;
        }
        // Write a new line to separate each word from the next
        cout << endl;
    }

    return 0;
}
