#include "binary_search.hh"

#include <cassert>
#include <vector>

int main() {
    std::vector<int> xs;
    for (int i = 0; i < 90000000; ++i)
        xs.push_back(i);
    for (int i = 0; i < 90000000; i += 10000)
        assert(binary_search(xs.begin(), xs.end(), i));
    assert(!binary_search(xs.begin(), xs.end(), -1));
    assert(!binary_search(xs.begin(), xs.end(), -42));
    assert(!binary_search(xs.begin(), xs.end(), -1984));
    assert(!binary_search(xs.begin(), xs.end(), -90000000));
    assert(!binary_search(xs.begin(), xs.end(), 90000000));
    assert(!binary_search(xs.begin(), xs.end(), 99999999));

    return 0;
}
