#ifndef BINARY_SEARCH_HH
#define BINARY_SEARCH_HH

template<class Ran, class X>
bool binary_search(Ran begin, Ran end, const X& x) {
    while (begin < end) {
        // Find midpoint of range
        Ran mid = begin + (end - begin) / 2;
        // See which sub-range contains `x`, and adapt range
        if (x < *mid) end = mid;
        else if (*mid < x) begin = mid + 1;
        else return true; // `*mid == x` so we're done
    }
    return false;
}

#endif
