#include "copy.hh"

#include <cassert>
#include <list>
#include <vector>

int main() {
    {
        int src[] = { 1, 2, 3, 4, 5 };
        int dst[sizeof (src) / sizeof (src[0])] = { 0 };
        ::copy(&src[1], &src[4], &dst[0]);
        assert(dst[0] == 2);
        assert(dst[1] == 3);
        assert(dst[2] == 4);
        assert(dst[3] == 0);
    }

    {
        std::list<int> src = { 1, 2, 3, 4, 5 };
        int dst[16] = { 0 };
        ::copy(++src.begin(), --src.end(), dst);
        assert(dst[0] == 2);
        assert(dst[1] == 3);
        assert(dst[2] == 4);
        assert(dst[3] == 0);
    }

    {
        std::vector<char> src = { '1', '2', '3', '4', '5' };
        char dst[16] = { 0 };
        ::copy(++src.begin(), --src.end(), dst);
        assert(dst[0] == '2');
        assert(dst[1] == '3');
        assert(dst[2] == '4');
        assert(dst[3] == 0);
    }

    return 0;
}
