#include "Student_info_2.hh"

#include <algorithm>

#include "grade.hh"

using namespace std;

int main() {
    // Read all the records, and find the length of the longest name
    Student_info record;
    vector<Student_info> students;
    string::size_type maxlen = 0;
    while (record.read(cin)) {                        // Changed
        maxlen = max(maxlen, record.name().size());   // Changed
        students.push_back(record);
    }

    // Alphabetize the records
    sort(students.begin(), students.end(), compare);

    auto prec = cout.precision(3);
    for (vector<Student_info>::size_type i = 0;
            i != students.size(); ++i) {
        // Write the name, padded on the right
        cout << students[i].name() // This and next line changed
             << string(maxlen + 1 - students[i].name().size(), ' ');
        // Compute and write the grade
        try {
            double final_grade = students[i].grade(); // Changed
            cout << final_grade << endl;
        } catch (domain_error e) {
            cerr << e.what() << endl;
        }
    }
    cout.precision(prec); // Restore precision

    return 0;
}
