#include <algorithm>
#include <iostream>
#include <iterator>
#include <list>
#include <vector>

using namespace std;

template<class Seq>
void in_out(Seq& xs) {
    cout << "Type in a few numbers, followed by Ctrl-D (i.e. end-of-file)."
         << endl;
    typedef typename Seq::value_type Elem;
    copy(istream_iterator<Elem>(cin),
         istream_iterator<Elem>(),
         back_inserter(xs));
    copy(xs.begin(), xs.end(),
         ostream_iterator<Elem>(cout, " "));
    cout << endl;
}

int main() {
    cout << "Choose a data structure:" << endl
         << endl
         << "1. std::vector<int>" << endl
         << "2. std::vector<double>" << endl
         << "3. std::list<int>" << endl
         << endl
         << "Your choice? ";
    unsigned choice;
    cin >> choice;
    switch (choice) {
        case 1: {
            vector<int> xs;
            in_out(xs);
            break;
        }
        case 2: {
            vector<double> xs;
            in_out(xs);
            break;
        }
        case 3: {
            list<int> xs;
            in_out(xs);
            break;
        }
        default:
            cerr << "Come back when you'll know what you want." << endl;
            return 1;
    }

    return 0;
}
