#ifndef MEDIAN_HH
#define MEDIAN_HH

#include <algorithm>
#include <stdexcept>
#include <vector>

template<class T>
T median(std::vector<T> v) {
    auto size = v.size();
    if (size == 0)
        throw std::domain_error("median of an empty vector");
    sort(v.begin(), v.end());
    auto mid = size / 2;
    return size % 2 == 0 ? (v[mid] + v[mid - 1]) / 2 : v[mid];
}

#endif
