#include "split.hh"

#include <cassert>
#include <iostream>
#include <iterator>
#include <list>
#include <vector>

using namespace std;

int main() {
    {
        vector<string> xs;
        split(" One Two Three ", back_inserter(xs));
        assert(xs.size() == 3);
        assert(xs[0] == "One");
        assert(xs[1] == "Two");
        assert(xs[2] == "Three");
    }

    {
        list<string> xs;
        split(" One Two Three ", back_inserter(xs));
        assert(xs.size() == 3);
        assert(xs.front() == "One");
        assert(xs.back() == "Three");
    }

    {
        split("  One Two Three ",
              ostream_iterator<string>(cout, "\n"));
    }

    return 0;
}
