#ifndef SPLIT_HH
#define SPLIT_HH

#include <algorithm>
#include <cctype>
#include <string>

template<class Out>                          // Changed
void split(const std::string& str, Out os) { // Changed
    typedef std::string::const_iterator Iter;

    Iter i = str.begin();
    while (i != str.end()) {
        // Ignore leading blanks
        i = std::find_if_not(i, str.end(), isspace);
        // find end of next word
        Iter j = std::find_if(i, str.end(), isspace);
        // Copy characters in `[i, j)`
        if (i != str.end())
            *os++ = std::string(i, j);       // Changed
        i = j;
    }
}

#endif
