#include <cassert>
#include <cstddef>
#include <iterator>

using std::end;

#define IMAGE_SIZE(width, height, n_channels, depth) \
    (width * height * n_channels \
     * ((depth % 8 == 0) ? (depth / 8) : (depth / 8 + 1)))

static uint8_t a98[IMAGE_SIZE(1980, 720, 3, 8)];

constexpr size_t image_size(size_t width, size_t height,
                            size_t n_channels, size_t depth) {
    size_t bytes_per_pixel =
        (depth % 8 == 0) ? (depth / 8) : (depth / 8 + 1);
    return width * height * n_channels * bytes_per_pixel;
}

static uint8_t a11[image_size(1980, 720, 3, 8)];

int main() {
    assert(IMAGE_SIZE(100, 200, 3, 9) == 100 * 200 * 3 * 2);
    assert(image_size(100, 200, 3, 9) == 100 * 200 * 3 * 2);
    assert(end(a98) == &a98[1980 * 720 * 3]);
    assert(end(a11) == &a11[1980 * 720 * 3]);
    return 0;
}
