#include <cassert>
#include <iterator>

using std::begin;
using std::end;

template<class In, class Pred>
In find_if(In begin, In end, Pred f) { // Note `f` type
    while (begin != end && !f(*begin)) // Note `f` call
        ++begin;
    return begin;
}

static bool is_two(int i) { return i == 2; }

int main() {
    int a[] = { 1, 2, 3 };
    // `a` is pointer to first element, i.e. &a[0]
    assert(find_if(a,        &a[3],  is_two) == &a[1]);
    assert(find_if(begin(a), end(a), is_two) == &a[1]);
    return 0;
}
