#include "vec3.hh"

#include <cassert>

int main() {
    Vec<int> v1;
    assert(v1.size() == 0);

    Vec<int> v2(10);
    assert(v2.size() == 10);
    assert(v2[0] == 0);
    assert(v2[1] == 0);
    v2[1] = 42;
    assert(v2[1] == 42);
    const int& v2_1 = v2[1];
    assert(v2_1 == 42);

    int i = 0;
    for (Vec<int>::iterator it = v2.begin(); it != v2.end(); ++it)
        *it = i++;

    v1 = v2;
    assert(v1.size() == 10);
    v2[0] = 1984;
    assert(v2[0] == 1984);

    i = 0;
    for (Vec<int>::const_iterator it = v1.begin(); it != v1.end(); ++it)
        assert(*it == i++); // Note that v1[0] is still 0, not 1984

    Vec<int> v3(v1);
    assert(v3.size() == 10);
    i = 0;
    for (Vec<int>::const_iterator it = v3.begin(); it != v3.end(); ++it)
        assert(*it == i++);

    return 0;
}
