#include "str_full.hh"

#include <cassert>

using namespace std;

ostream& operator<<(ostream& os, const Str& s) {
    for (Str::size_type i = 0; i != s.size(); ++i)
        os << s[i];
    return os;
}

istream& operator>>(istream& is, Str& s) {
    // Obliterate existing value(s)
    s.data.clear();
    // Read and discard leading blanks
    char c;
    while (is.get(c) && isspace(c))
        ; // Nothing to do, except testing the condition

    // If we read a non-blank char, continue to read
    // until next whitespace character
    if (is) {
        do { s.data.push_back(c); }
        while (is.get(c) && !isspace(c));
        // If we read a blank, put it back on the stream
        if (is)
            is.unget();
    }
    return is;
}

Str operator+(const Str& lhs, const Str& rhs) {
    Str res = lhs; // Copy constructor
    res += rhs; // res.operator+=(rhs)
    return res; // Copy constructor*
}

int main() {
    Str empty;
    assert(empty.size() == 0);
    Str as(100, 'a');
    assert(as.size() == 100);
    for (Str::size_type i = 0; i < as.size(); ++i) {
        assert(as[i] == 'a');
    }
    const char *p = "Hello";
    Str hello(p);
    assert(hello.size() == 5);
    assert(hello[0] == 'H');
    assert(hello[1] == 'e');
    assert(hello[4] == 'o');
    Str ell(&p[1], &p[4]);
    assert(ell.size() == 3);
    assert(ell[0] == 'e');
    assert(ell[2] == 'l');
    ell[0] = 'Z';
    assert(ell[0] == 'Z');
    assert(ell[1] == 'l');

    Str prompt = "What's ";
    prompt += "your name? ";
    cout << prompt;
    Str name;
    cin >> name;
    Str greeting = "Hello, " + name + "!";
    cout << greeting << endl;

    return 0;
}
