#ifndef STR_HH
#define STR_HH

#include <cstring>
#include <iostream>
#include <vector>

class Str {
public:
    typedef std::vector<char>::size_type size_type;

    Str() { }

    Str(size_type n, char c): data(n, c) { }

    Str(const char* cp) {
        std::copy(cp, cp + std::strlen(cp),
                  std::back_inserter(data));
    }

    template<class In> Str(In i, In j) {
        std::copy(i, j, std::back_inserter(data));
    }

    size_type size() const { return data.size(); }

    char& operator[](size_type i) { return data[i]; }
    const char& operator[](size_type i) const {
        return data[i];
    }

    friend std::istream& operator>>(std::istream&, Str&);

    Str& operator+=(const Str& s) {
        std::copy(s.data.begin(), s.data.end(),
                  std::back_inserter(data));
        return *this;
    }

private:
    std::vector<char> data;
};

Str operator+(const Str& lhs, const Str& rhs);

std::istream& operator>>(std::istream&, Str&);
std::ostream& operator<<(std::ostream&, const Str&);

#endif
