#ifndef STR_HH
#define STR_HH

#include <cstring>
#include <vector>

class Str {
public:
    typedef std::vector<char>::size_type size_type;

    Str() { }

    Str(size_type n, char c): data(n, c) { }

    Str(const char* cp) {
        std::copy(cp, cp + std::strlen(cp),
                  std::back_inserter(data));
    }

    template<class In> Str(In i, In j) {
        std::copy(i, j, std::back_inserter(data));
    }

private:
    std::vector<char> data;
};

#endif
