#include <algorithm>
#include <iostream>
#include <vector>

#include "grad.hh"

using namespace std;

static
bool compare_Core_ptrs(const Core* cp1, const Core* cp2) {
    return compare(*cp1, *cp2);
}

int main() {
    vector<Core*> students; // Store pointers, not objects
    Core* record; // Temporary must be a pointer as well
    char ch;
    string::size_type max_len = 0;

    // Read and store the student records
    while (cin >> ch) {
        if (ch == 'U')
            record = new Core; // Allocate a Core object
        else
            record = new Grad; // Allocate a Grad object
        record->read(cin); // Virtual call
        max_len = max(max_len, record->name().size());
                                  // ^ Dereference
        students.push_back(record);
    }

    // Pass the version of compare() that works on pointers
    sort(students.begin(), students.end(), compare_Core_ptrs);

    // Write the names and grades
    for (auto s : students) {
        // s is a pointer
        cout << s->name() // Dereference to call function
             << string(max_len + 1 - s->name().size(), ' ');
        try {
            cout << s->grade() << endl; // Dereference to call

        } catch (domain_error e) {
            cerr << e.what() << endl;
        }
        delete s; // Free the object allocated when reading
    }
    return 0;
}
