#include <algorithm>
#include <iostream>
#include <vector>

#include "student_info.hh"

using namespace std;

int main() {
    vector<Student_info> students;
    Student_info record;
    string::size_type max_len = 0;
    // Read and store the student records
    while (record.read(cin)) {
        max_len = max(max_len, record.name().size());
        students.push_back(record);
    }
    // Alphabetize the student records
    sort(students.begin(), students.end(), Student_info::compare);
    // Write the names and grades
    for (auto& s : students) {
        cout << s.name()
             << string(max_len + 1 - s.name().size(), ' ');
        try {
            cout << s.grade() << endl;
        } catch (domain_error e) {
            cerr << e.what() << endl;
        }
    }
    return 0;
}
