#include "core.hh"

#include "grade.hh"

using std::istream;
using std::string;

Core::Core() : midterm(0), final(0) { }

Core::Core(istream& is) { read(is); }

string Core::name() const { return _name; }

double Core::grade() const {
    return ::grade(midterm, final, homeworks);
}

istream& Core::read_common(istream& in) {
    // Read and store student's name and exam grades
    in >> _name >> midterm >> final;
    return in;
}

istream& Core::read(istream& in) {
    read_common(in);
    read_hws(in, homeworks);
    return in;
}
